<?php
/*
 * ----------------------------------------------------------------------
 *
 *                          Borlabs Cookie
 *                      developed by Borlabs
 *
 * ----------------------------------------------------------------------
 *
 * Copyright 2018 Borlabs - Benjamin A. Bornschein. All rights reserved.
 * This file may not be redistributed in whole or significant part.
 * Content of this file is protected by international copyright laws.
 *
 * ----------------- Borlabs Cookie IS NOT FREE SOFTWARE -----------------
 *
 * @copyright Borlabs - Benjamin A. Bornschein, https://borlabs.io
 * @author Benjamin A. Bornschein, Borlabs ben@borlabs.io
 *
 */

namespace BorlabsCookie\Cookie\Frontend\BlockedContentTypes;

use BorlabsCookie\Cookie\Frontend\ContentBlocker;

class Custom
{
    private static $instance;

    public static function getInstance()
    {
        if (null === self::$instance) {
            self::$instance = new self;
        }

        return self::$instance;
    }

    private function __clone()
    {
    }

    private function __wakeup()
    {
    }

    protected function __construct()
    {
    }

    /**
     * modify function.
     *
     * @access public
     * @param mixed $id
     * @param mixed $content
     * @param mixed $typeId
     * @return void
     */
    public function modify($id, $content, $typeId)
    {
        // Get settings of the Blocked Content Type
        $bctData = ContentBlocker::getInstance()->getDataOfBlockedContentType($typeId);

        // Get the title which was maybe set via title-attribute in a shortcode
        $title = ContentBlocker::getInstance()->getCurrentTitle();

        // If no title was set use the Blocked Content Type name as title
        if (empty($title)) {
            $title = $bctData['name'];
        }

        // Replace text variables
        $bctData['previewHTML'] = str_replace('%%name%%', $title, $bctData['previewHTML']);

        return $bctData['previewHTML'];
    }
}
