<?php
/*
 * ----------------------------------------------------------------------
 *
 *                          Borlabs Cookie
 *                      developed by Borlabs
 *
 * ----------------------------------------------------------------------
 *
 * Copyright 2018 Borlabs - Benjamin A. Bornschein. All rights reserved.
 * This file may not be redistributed in whole or significant part.
 * Content of this file is protected by international copyright laws.
 *
 * ----------------- Borlabs Cookie IS NOT FREE SOFTWARE -----------------
 *
 * @copyright Borlabs - Benjamin A. Bornschein, https://borlabs.io
 * @author Benjamin A. Bornschein, Borlabs ben@borlabs.io
 *
 */

namespace BorlabsCookie\Cookie\Frontend\BlockedContentTypes;

use BorlabsCookie\Cookie\Frontend\ContentBlocker;

class Facebook
{
    private static $instance;

    public static function getInstance()
    {
        if (null === self::$instance) {
            self::$instance = new self;
        }

        return self::$instance;
    }

    private function __clone()
    {
    }

    private function __wakeup()
    {
    }

    protected function __construct()
    {
    }

    /**
     * getDefault function.
     *
     * @access public
     * @return void
     */
    public function getDefault()
    {
        $data = [
            'typeId'=>'facebook',
            'name'=>'Facebook',
            'description'=>'',
            'hosts'=>[
                'facebook.com',
                'connect.facebook.net',
            ],
            'previewHTML'=>'<div class="borlabs-cookie-bct bc-bct-social bc-bct-facebook">
    <p class="bc-thumbnail"><img src="%%thumbnail%%" alt="%%name%%"></p>
    <div class="bc-text">
        <p>'._x('To protect your personal data, your connection to Facebook has been blocked.<br>Click on <strong>Load post</strong> to unblock Facebook.<br>By loading the post you accept the privacy policy of Facebook.<br>More information about Facebooks\'s privacy policy can be found here <a href="https://www.facebook.com/privacy/explanation" target="_blank" rel="nofollow">Facebook Data Policy</a>.', 'Blocked Content Types - Facebook', 'borlabs-cookie').'</p>
        <p><label><input type="checkbox" name="unblockAll" value="1" checked> '._x('Do not block Facebook posts in the future anymore.', 'Blocked Content Types - Facebook', 'borlabs-cookie').'</label>
        <a role="button" data-borlabs-cookie-unblock>'._x('Load post', 'Blocked Content Types', 'borlabs-cookie').'</a></p>
    </div>
</div>',
            'globalJS'=>'',
            'initJS'=>'if(typeof FB === "object") { FB.XFBML.parse(document.getElementById(id)); }',
            'settings'=>[],
            'status'=>true,
            'undeleteable'=>true,
        ];

        return $data;
    }

    /**
     * modify function.
     *
     * @access public
     * @param mixed $id
     * @param mixed $content
     * @return void
     */
    public function modify($id, $content)
    {
        // Get settings of the Blocked Content Type
        $bctData = ContentBlocker::getInstance()->getDataOfBlockedContentType('facebook');

        // Default thumbnail
        $thumbnail = BORLABS_COOKIE_PLUGIN_URL.'images/bct-facebook.png';

        // Get the title which was maybe set via title-attribute in a shortcode
        $title = ContentBlocker::getInstance()->getCurrentTitle();

        // If no title was set use the Blocked Content Type name as title
        if (empty($title)) {
            $title = $bctData['name'];
        }

        // Replace text variables
        $bctData['previewHTML'] = str_replace(
            [
                '%%name%%',
                '%%thumbnail%%',
            ],
            [
                $title,
                $thumbnail
            ],
            $bctData['previewHTML']
        );

        return $bctData['previewHTML'];
    }
}
