<?php
/*
 * ----------------------------------------------------------------------
 *
 *                          Borlabs Cookie
 *                      developed by Borlabs
 *
 * ----------------------------------------------------------------------
 *
 * Copyright 2018 Borlabs - Benjamin A. Bornschein. All rights reserved.
 * This file may not be redistributed in whole or significant part.
 * Content of this file is protected by international copyright laws.
 *
 * ----------------- Borlabs Cookie IS NOT FREE SOFTWARE -----------------
 *
 * @copyright Borlabs - Benjamin A. Bornschein, https://borlabs.io
 * @author Benjamin A. Bornschein, Borlabs ben@borlabs.io
 *
 */

namespace BorlabsCookie\Cookie\Frontend\BlockedContentTypes;

use BorlabsCookie\Cookie\Frontend\ContentBlocker;
use BorlabsCookie\Cookie\Frontend\JavaScript;

class GoogleMaps
{
    private static $instance;

    public static function getInstance()
    {
        if (null === self::$instance) {
            self::$instance = new self;
        }

        return self::$instance;
    }

    private function __clone()
    {
    }

    private function __wakeup()
    {
    }

    /**
     * __construct function.
     *
     * @access protected
     * @return void
     */
    protected function __construct()
    {
        add_action('borlabsCookie/bct/edit_template/googlemaps', [$this, 'additionalSettingsTemplate']);
    }

    /**
     * getDefault function.
     *
     * @access public
     * @return void
     */
    public function getDefault()
    {
        $data = [
            'typeId'=>'googlemaps',
            'name'=>'Google Maps',
            'description'=>'',
            'hosts'=>[
                'maps.google.com',
                'www.google.com/maps/',
            ],
            'previewHTML'=>'<div class="borlabs-cookie-bct bc-bct-iframe bc-bct-google-maps">
    <p class="bc-thumbnail"><img src="%%thumbnail%%" alt="%%name%%"></p>
    <div class="bc-text">
        <p>'._x('To protect your personal data, your connection to Google Maps has been blocked.<br>Click on <strong>Load map</strong> to unblock Google Maps.<br>By loading the map you accept the privacy policy of Google.<br>More information about Google\'s privacy policy can be found here <a href="https://policies.google.com/privacy?hl=en&amp;gl=en" target="_blank" rel="nofollow">Google - Privacy &amp; Terms</a>.', 'Blocked Content Types - Google Maps', 'borlabs-cookie').'</p>
        <p><label><input type="checkbox" name="unblockAll" value="1" checked> '._x('Do not block Google Maps in the future anymore.', 'Blocked Content Types - Google Maps', 'borlabs-cookie').'</label>
        <a role="button" data-borlabs-cookie-unblock>'._x('Load map', 'Blocked Content Types', 'borlabs-cookie').'</a></p>
    </div>
</div>',
            'globalJS'=>'',
            'initJS'=>'',
            'settings'=>[
                'responsiveIframe'=>true,
            ],
            'status'=>true,
            'undeleteable'=>true,
        ];

        return $data;
    }

    /**
     * modify function.
     *
     * @access public
     * @param mixed $id
     * @param mixed $content
     * @return void
     */
    public function modify($id, $content)
    {
        // Get settings of the Blocked Content Type
        $bctData = ContentBlocker::getInstance()->getDataOfBlockedContentType('googlemaps');

        // Check if the iframe should be made responsive
        if (!empty($bctData['settings']['responsiveIframe'])) {

            // Add wrapper around the iframe, size is handled via CSS
            $content = '<div class="borlabs-cookie-responsive-iframe-wrapper">'.$content.'</div>';

            // Add the modified content to the Blocked Content list, overwrite the old content
            JavaScript::getInstance()->addBlockedContent('googlemaps', $id, $content);
        }

        // Default thumbnail
        $thumbnail = BORLABS_COOKIE_PLUGIN_URL.'images/bct-google-maps.png';

        // Get the title which was maybe set via title-attribute in a shortcode
        $title = ContentBlocker::getInstance()->getCurrentTitle();

        // If no title was set use the Blocked Content Type name as title
        if (empty($title)) {
            $title = $bctData['name'];
        }

        // Replace text variables
        $bctData['previewHTML'] = str_replace(
            [
                '%%name%%',
                '%%thumbnail%%',
            ],
            [
                $title,
                $thumbnail
            ],
            $bctData['previewHTML']
        );

        return $bctData['previewHTML'];
    }

    /**
     * additionalSettingsTemplate function.
     *
     * @access public
     * @param mixed $data
     * @return void
     */
    public function additionalSettingsTemplate($data)
    {
        $checkboxResponsiveIframe = !empty($data->settings['responsiveIframe']) ? ' checked' : '';
        ?>
        <div class="form-group">
            <div class="form-title"><?php _ex('Responsive Iframe', 'Setting title', 'borlabs-cookie'); ?></div>
            <div class="form-field">
                <label for="responsiveIframe">
                    <input<?php echo $checkboxResponsiveIframe; ?> type="checkbox" name="settings[responsiveIframe]" id="responsiveIframe" value="1"> <span class="option-title"><?php _ex('Activate', 'Setting checkbox', 'borlabs-cookie'); ?></span>
                </label>
                <span class="description"><?php _ex('The width and height will be replaced to get the iframe responsive.', 'Setting description', 'borlabs-cookie'); ?></span>
            </div>
        </div>
        <?php
    }
}
