<?php
/*
 * ----------------------------------------------------------------------
 *
 *                          Borlabs Cookie
 *                      developed by Borlabs
 *
 * ----------------------------------------------------------------------
 *
 * Copyright 2018 Borlabs - Benjamin A. Bornschein. All rights reserved.
 * This file may not be redistributed in whole or significant part.
 * Content of this file is protected by international copyright laws.
 *
 * ----------------- Borlabs Cookie IS NOT FREE SOFTWARE -----------------
 *
 * @copyright Borlabs - Benjamin A. Bornschein, https://borlabs.io
 * @author Benjamin A. Bornschein, Borlabs ben@borlabs.io
 *
 */

namespace BorlabsCookie\Cookie\Frontend;

use BorlabsCookie\Cookie\Config;
use BorlabsCookie\Cookie\Tools;

class Shortcode
{
    private static $instance;

    public static function getInstance()
    {
        if (null === self::$instance) {
            self::$instance = new self;
        }

        return self::$instance;
    }

    public function __construct()
    {
    }

    private function __clone()
    {
    }

    private function __wakeup()
    {
    }

    /**
     * shortcodeForCookieSelectionBox function.
     *
     * @access public
     * @param mixed $atts
     * @param mixed $content (default: null)
     * @return void
     */
    public function shortcodeForCookieSelectionBox($atts, $content = null)
    {
        $html = '';

        $align = 'left';

        if (!empty($atts['align'])) {
            if ($atts['align'] === 'left-float') {
                $align = 'left-float';
            } elseif ($atts['align'] === 'right') {
                $align = 'right';
            } elseif ($atts['align'] === 'right-float') {
                $align = 'right-float';
            } elseif ($atts['align'] === 'center') {
                $align = 'center';
            }
        }

        $textExplanation = Config::getInstance()->get('textExplanation');

        $textExplanation = str_replace(
            [
                '%%privacy_url%%',
                '%%privacy_title%%',
                '%%imprint_url%%',
                '%%imprint_title%%',
            ],
            [
                Config::getInstance()->get('privacyPageURL'),
                Config::getInstance()->get('privacyPageTitle'),
                Config::getInstance()->get('imprintPageURL'),
                Config::getInstance()->get('imprintPageTitle'),
            ],
            $textExplanation
        );

        $textHelpBottom = Config::getInstance()->get('textHelpBottom');

        $textHelpBottom = str_replace(
            [
                '%%privacy_url%%',
                '%%privacy_title%%',
                '%%imprint_url%%',
                '%%imprint_title%%',
            ],
            [
                Config::getInstance()->get('privacyPageURL'),
                Config::getInstance()->get('privacyPageTitle'),
                Config::getInstance()->get('imprintPageURL'),
                Config::getInstance()->get('imprintPageTitle'),
            ],
            $textHelpBottom
        );

        $templatePath = realpath(dirname(__FILE__).'/../../../templates');
        $file = $templatePath.'/cookie-content-box.html';

        if (file_exists($file)) {
            ob_start();
            include($file);
            $html = ob_get_contents();
            ob_end_clean();
        }

        return $html;
    }

    /**
     * shortcodeForCookieLog function.
     *
     * @access public
     * @param mixed $atts
     * @param mixed $content (default: null)
     * @return void
     */
    public function shortcodeForCookieLog($atts, $content = null)
    {
        $html = '';

        $html = '<div data-borlabs-cookie-log><table><thead><tr><th>'.Config::getInstance()->get('textLogColumnTitleStamp').'</th><th>'.Config::getInstance()->get('textLogColumnTitleUserAction').'</th></tr></thead></table></div>';

        return $html;
    }

    /**
     * shortcodeForCookieUID function.
     *
     * @access public
     * @param mixed $atts
     * @param mixed $content (default: null)
     * @return void
     */
    public function shortcodeForCookieUID($atts, $content = null)
    {
        $html = '';

        $html = '<span data-borlabs-cookie-uid></span>';

        return $html;
    }

    /**
     * shortcodeForCookieThirdParty function.
     *
     * @access public
     * @param mixed $atts
     * @param mixed $content (default: null)
     * @return void
     */
    public function shortcodeForCookieThirdParty($atts, $content = null)
    {
        return '<div data-borlabs-cookie-inline="third-party" data-borlabs-cookie-id="bc'.Tools::getInstance()->generateRandomString(8).'">'.base64_encode(do_shortcode($content)).'</div>';
    }

    /**
     * shortcodeForCookieFirstParty function.
     *
     * @access public
     * @param mixed $atts
     * @param mixed $content (default: null)
     * @return void
     */
    public function shortcodeForCookieFirstParty($atts, $content = null)
    {
        return '<div data-borlabs-cookie-inline="first-party" data-borlabs-cookie-id="bc'.Tools::getInstance()->generateRandomString(8).'">'.base64_encode(do_shortcode($content)).'</div>';
    }

    /**
     * shortcodeForBlockedContent function. DEPRECATED
     *
     * @access public
     * @param mixed $atts
     * @param mixed $content (default: null)
     * @return void
     */
    public function shortcodeForBlockedContent($atts, $content = null)
    {
        return '<div>Borlabs Cookie: Function <strong>shortcodeForBlockedContent</strong> is deprecated.</div>';
    }

    /**
     * shortcodeForOptOut function.
     *
     * @access public
     * @param mixed $atts
     * @param mixed $content (default: null)
     * @return void
     */
    public function shortcodeForOptOut($atts, $content = null)
    {
        $matchTracking = [
            'google-analytics'=>'Google Analytics',
            'facebook-pixel'=>'Facebook Pixel',
        ];

        $textOptOut = Config::getInstance()->get('textOptOut');
        $textOptOutSuccess = Config::getInstance()->get('textOptOutSuccess');

        $textOptOut = str_replace(
            [
                '%%tracking_title%%',
                '%%tracking%%',
            ],
            [
                !empty($atts['tracking']) && !empty($matchTracking[$atts['tracking']]) ? $matchTracking[$atts['tracking']] : '-',
                !empty($atts['tracking']) ? $atts['tracking'] : '-',
            ],
            $textOptOut
        );

        $textOptOutSuccess = str_replace(
            [
                '%%tracking_title%%',
            ],
            [
                !empty($atts['tracking']) && !empty($matchTracking[$atts['tracking']]) ? $matchTracking[$atts['tracking']] : '-',
            ],
            $textOptOutSuccess
        );

        return '<div data-borlabs-cookie-opt-out="'.(!empty($atts['tracking']) ? $atts['tracking'] : '-').'"'.(!empty($atts['id']) ? ' data-borlabs-cookie-tracking-id="'.$atts['id'].'"' : '').'><p>'.$textOptOut.'</p><p data-borlabs-cookie-opt-out-success>'.$textOptOutSuccess.'</p></div>';
    }
}
